<?php 

function sendRequest($username, $password){
	
	if(empty($username))
		throw new Exception("Informe um CPF, Tente novamente.", 1);
	
	$default_endpoint = [
		'https://app.associatec.com.br/Api/Associados/AssociadoLista?valorBusca=',
		// 'https://residencia.neurocirurgia.org.br/api/v1/users/is-member?cpf='
	];

	$curl = curl_init();
	curl_setopt_array($curl, array(
	  CURLOPT_URL =>  'https://app.associatec.com.br/Api/Permissao/Login',
	  CURLOPT_RETURNTRANSFER => true,
	  CURLOPT_ENCODING => "",
	  CURLOPT_MAXREDIRS => 10,
	  CURLOPT_TIMEOUT => 30,
	  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	  CURLOPT_CUSTOMREQUEST => "POST",
	  CURLOPT_POSTFIELDS => "{login: '$username', senha: '$password',}",
	  CURLOPT_HTTPHEADER => array(
	    "authorization: basic 1009092427",
	    "cache-control: no-cache",
	    "content-type: application/x-www-form-urlencoded",
	  ),
	));

	$response = curl_exec($curl);
	$err = curl_error($curl);
	curl_close($curl);

	if ($err) 
		error_log("cURL Error #: " . $err);

    return json_decode( $response, true );

}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	
	$username = $_POST['login'];
	$password = $_POST['password'];

    try {
		
		// Enviando requisição para tentar encontrar algum usuario no banco de dados SBN Residencia Médica
    	$response = sendRequest($username, $password);
    	  
    	if($response['flagErro'] == true) {
    	    throw new \Exception($response['listaMensagens'][0]);
    	}
    	
    	if($response['listaResultados']['flagSituacaoContribuicao'] !== "AD") {
        	throw new \Exception("Favor, entrar entrar em contato com a Secretaria da SBN: faleconosco@sbn.com.br ou via (11) 3051-6075");
    	}

    	header('location: ' . $_GET['url']);
    	exit;

    } catch (\Exception $e) {
    	header('location: https://neurocirurgia.org.br/sso//sso/verify-on.php?error=' . $e->getMessage());
    	exit;
    }
}