<?php

/**
 * Description of RegistradorTeste
 *
 * @author Henrique
 */
class MyProject_RegistradorLogsMysql extends Zend_Db_Profiler {

    /**
     * Zend_Log instance
     * @var Zend_Log
     */
    protected $_log;

    /**
     * counter of the total elapsed time
     * @var double 
     */
    protected $_totalElapsedTime;

    public function __construct($enabled = false) {
        parent::__construct($enabled);

        $data = date('d-m-Y');
        $caminhoArquivoLog = "../logs_mysql/log_mysql_$data.log";
        $this->_log = new Zend_Log();
        $writer = new Zend_Log_Writer_Stream($caminhoArquivoLog);
        $this->_log->addWriter($writer);
    }

    /**
     * Intercept the query end and log the profiling data.
     *
     * @param  integer $queryId
     * @throws Zend_Db_Profiler_Exception
     * @return void
     */
    public function queryEnd($queryId) {
        $state = parent::queryEnd($queryId);

        if (!$this->getEnabled() || $state == self::IGNORED) {
            return;
        }

        // get profile of the current query
        $profile = $this->getQueryProfile($queryId);

        // update totalElapsedTime counter
        $this->_totalElapsedTime += $profile->getElapsedSecs();

        //
        $user = New Application_Model_User();
        $idUsuario = (isset($user->pegarSessaoUsuarioLogadoAtual()->id)) ? $user->pegarSessaoUsuarioLogadoAtual()->id : 1;

        //
        $query = $profile->getQuery();

        // create the message to be logged
        $message = "\r\nSegs decorridos: " . round($profile->getElapsedSecs(), 5) . "\r\n";
        $message .= "Query: " . $query . "\r\n";
        $message .= "Ip: " . $_SERVER['REMOTE_ADDR'] . "\r\n";
        $message.= "IdUser: " . $idUsuario . "\r\n";

        if (preg_match('(INSERT|UPDATE|DELETE)', $query) == true) :
            // Escreve no arquivo de log com um tipo de mensagem
            $this->_log->info($message);
        endif;
    }

}

?>