<?php
class MyProject_Controller_Plugin_Acl extends Zend_Controller_Plugin_Abstract
{
    public function preDispatch(Zend_Controller_Request_Abstract $request)
    {
        $auth = Zend_Auth::getInstance();
        //var_dump($auth->getIdentity());
        $authModel= new Application_Model_Auth();
        
        if (!$auth->hasIdentity()){
            //se não possuir identidade loga o usuário como visitante
            $authModel->authenticate(array('login'=>'VisitanteLogin','password'=>'12345678'));
            //$authModel->authenticate(array('login'=>'hrd.ramalho@gmail.com','password'=>'12345678'));
        }
 
        $request = $this->getRequest();
        $aclResource= new Application_Model_AclResource();
        //Checa se a requesição é valida, se não for seta o controlador de erro
        if( !$aclResource->resourceValid($request)){
            $request->setControllerName('error');
            $request->setActionName('error');
            return;
        }
 
        $controller = strtolower($request->getControllerName()) ;
        $action = strtolower($request->getActionName()) ;
        //Checa se o recurso solicidado (controlle e action) estão na base de dados. Se não estiver adiciona ao BD
        if( !$aclResource->resourceExists($controller, $action)){
            $aclResource->createResource($controller,$action);
        }

        // instancia a acl
        $acl = new Zend_Acl();
        
        // informa os papeis para a acl
        
        //Pega o papel
        $role_id = $auth->getIdentity()->role_id ; 
        $consulta_role = Application_Model_Role::getById($role_id);
        $role = $consulta_role[0]->role ;
        
        // Lista de papeis
        $arrPapelHeranca = $aclResource->pegarPapeisHeranca($role_id);
        if (count($arrPapelHeranca) > 0) :
            
            $arrayNomesPapeisHerancas = array() ;
            foreach ($arrPapelHeranca AS $arrPapelHerancaItem) :
                $acl->addRole(new Zend_Acl_Role($arrPapelHerancaItem['role']));
                $arrayNomesPapeisHerancas[] = $arrPapelHerancaItem['role']; 
            endforeach;
            $acl->addRole(new Zend_Acl_Role($role), $arrayNomesPapeisHerancas);
        else :
            $acl->addRole(new Zend_Acl_Role($role));
        endif ;
        
        // Pega os recursos existentes (controllers)
        $resources = $aclResource->getAllResources();
        // Adiciona os recursos à ACL
        foreach ($resources as $resource) {
            $acl->add(new Zend_Acl_Resource($resource->getController()));
        }

        // Pega os recursos disponíveis para este usuário. Uma array cujo indices são os nomes dos controllers, dentor de cada indice existe uma array simples com as actions
        $userAllowedResources = $aclResource->getCurrentRoleAllowedResources($role_id);
        //echo '<pre>' .print_r($userAllowedResources) .'</pre>' ;
        // Add the user permissions to ACL
        foreach ($userAllowedResources as $controllerName => $allowedActions) {
            $arrayAllowedActions = array();
            foreach ($allowedActions as $allowedAction) {
                $arrayAllowedActions[] = $allowedAction;
            }
 
            $acl->allow($role, strtolower((string)$controllerName), strtolower((string)$arrayAllowedActions));
        }
        
        // Pega os recursos disponíveis para as heranças
        foreach($arrPapelHeranca AS $arrPapelHerancaItem) :
            // Pega os recursos disponíveis para este usuário. Uma array cujo indices são os nomes dos controllers, dentor de cada indice existe uma array simples com as actions
            $userAllowedResources = $aclResource->getCurrentRoleAllowedResources($arrPapelHerancaItem['id']);

            // Add the user permissions to ACL
            foreach ($userAllowedResources as $controllerName => $allowedActions) {
                $arrayAllowedActions = array();
                foreach ($allowedActions as $allowedAction) {
                    $arrayAllowedActions[] = $allowedAction;
                }

                $acl->allow($arrPapelHerancaItem['role'], strtolower((string)$controllerName), strtolower((string)$arrayAllowedActions));
            }    
       endforeach ;

       /*$parents = array();
       foreach ($acl->getRoles() as $inherit) {
            if ($acl->inheritsRole($role, $inherit)) {
                $parents[] = $inherit;
            }
        }*/

        //print_r($acl->getRoles()) ;
        //var_dump($acl->hasRole('Secretaria')) ;       
        
        $arr = array("residente", "administracao-site", "sistema", 
        		"v-joint-meeting", "meeting", 'admin-v-joint-meeting', 
        		'chefe-de-servico', 'autenticacao', 'sistema-residencia', 
        		'incluir-novo-servico-de-residencia-acesso-publico', 
        		'sistema-residencia-solicitacao-de-cadastro-publico-externo', 'logs',
        		"sistema-residencia-graficos", "acl",
        		"financeiro", "organizacao-politica",
       			"consultas-para-diagnostico-de-erro", "relatorios-para-ti",
        		"correspondencias", "gerenciar-video-aulas",
        		"gerenciar-cursos-e-eventos" 
       ); 
        if (in_array($controller, $arr)) { 
            $request->setControllerName($controller);
            $request->setActionName($action);
            return;
        } 
        
        //echo $role .' ' .strtolower($controller) .' ' .strtolower(($action)) .' ' ;
        //var_dump($acl->isAllowed($role, strtolower($controller), strtolower($action))) ;
/*

       
        echo $role .'<br/>' ; 
        echo $role_id .'<br/>' ;
        echo $controller .'<br/>' ;
        echo $action .'<br/>' ;
*/        
        // Verifica se o usuário é altorizado a acessar a url e redireciona se nao for autorizado
        if ($acl->isAllowed($role, strtolower($controller), strtolower($action)) == false) {
            //echo "Este papel $role nao pode ver $controller - $action" ;
      
           // pega a url solicitada
           $protocolo = strtolower(substr($_SERVER["SERVER_PROTOCOL"],0,strpos( $_SERVER["SERVER_PROTOCOL"],'/'))).'://' ;
           $urlSolicitada = $protocolo . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];    
           
            // Registra tentativa frustrada de acesso
           $aclResource->registrarLogNegacao($controller, $action, $role_id, $auth->getIdentity()->id, $urlSolicitada) ;
            
           //$request->setControllerName('error'); // desabilitado em 30/10/2014
           $request->setControllerName($controller);
            //$request->setActionName('access-denied');  // desabilitado em 30/10/2014
           $request->setActionName($action);
            return;
        } else {
            //echo 'permitido' ;
            $request->setControllerName($controller);
            $request->setActionName($action);       
            return;
        }     
    }
}